<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Http\Requests\UserRequest;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Redirect;
use DB;
class UserController extends Controller
{
    /**
     * Display a listing of the users
     *
     * @param  \App\Models\User  $model
     * @return \Illuminate\View\View
     */
    public function index(User $model)
    {
       
    $currentURL = url()->current();
    $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $uri_segments = explode('/', $uri_path);
    $url=$uri_segments[2];
    $role=auth()->user()->role;
    $priviledge=auth()->user()->privileges;
    $priviledge=explode(',',$priviledge);
    // $priviledge=array('user1','useredit');
    if($role=="adminuser"){
        if(in_array($url, $priviledge)){
        $users = DB::table('users')->where('status','0')->get();
        return view('users.userlist',compact(['users']));
       }
      else{

      $this->meesage('accessmessage','User List Access Denied!');
      //return Redirect::back();
       return redirect('/home');
      }
    }else{
        $users = DB::table('users')->where('status','0')->get();
        return view('users.userlist',compact(['users']));
    }
    

    
      // return redirect::back()->with('message','Operation Successful !');
      

       
    }
    public function adduser(){

       return view('users.adduser');
    }
    public function save(Request $request){
      
      $rules1 = [
          'name' => 'required|min:2',
          'password' =>'required|string|min:8',
          'role' => 'required',

      ];
      $id=$request->id;
      if($request->id==""){
        $rules2= ['email' => 'required|unique:users'];
      }
      else{
        $rules2= ['email' => 'required|unique:users,id,'.$id];
      }
      $rules=array_merge($rules1,$rules2);  
      $errorMessage = [
          'required' => 'Enter your :attribute first.'
      ];
 
      $this->validate($request, $rules, $errorMessage);
      if($request->privileges!=""){
         $privileges=implode(',',$request->privileges);
      }else{$privileges="";}
      if($request->id==""){
        User::create([
         'name'    => $request->name,
         'email'    => $request->email,
         'password' => Hash::make($request['password']),
         'role'      => $request->role,
         'privileges'=>$privileges
         ]);
        $this->meesage('message','User created successfully!');
        }
        
    
     
      //return redirect()->back();
       return redirect('user');
    }
    public function edituser(User $user)
    { 
        return view('users.edituser',compact('user'));
    }
     public function updateuser(Request $request, User $user){
      $id=$request->id;
       $rules = [
          'name' =>'required|min:2',
          'email'=>'required|unique:users,email,'.$id,
          'role' => 'required',];
       
      $errorMessage = [
          'required' => 'Enter your :attribute first.'
      ];
 
      $this->validate($request, $rules, $errorMessage);
      if($request->privileges!=""){
         $privileges=implode(',',$request->privileges);
      }else{$privileges="";}
    
      $userup = User::find($request->id);
       
      
        $userup->name = $request->name;
        $userup->email = $request->email;
        $userup->role = $request->role;
        $userup->privileges=$privileges;
        $userup->update();        
      
      $this->meesage('message','User Updated successfully!');
      return redirect('user');
     }
    public function deleteuser($id){
      DB::delete('delete from users where id = ?',[$id]);
      $this->meesage('message','User deleted successfully!');
      return redirect('user');
    }
    public function meesage(string $name = null, string $message = null)
    {
        return session()->flash($name,$message);
    }
}
