@extends('layouts.app', ['pageSlug' => 'test'])
@push('style')
      <link rel="stylesheet" href="https://netdna.bootstrapcdn.com/bootstrap/3.3.2/css/bootstrap.min.css">
@endpush
@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-8">
         @if ($message = Session::get('success'))
            <div class="btn btn-success btn-block btn-sm custom_message text-left">
                <button type="button" class="close" data-dismiss="alert">×</button>    
                <strong>{{ $message }}</strong>
            </div>
          @endif
        <div class="card">  
            <div class="card-header">
                <h5 class="title">Add test</h5>
            </div>
            <div class="card-body">
             	{{Form::open([ 'id'=>'test','onsubmit'=>'return confirm("Please check the form once. Because did not provide edit to the form. Are you sure you want to submit this form?")'])}}
            <div class="form-group">
              <label for="">Test Name <span class="mandatory">* </span></label>
              {{Form::text('test_name',$test->test_name,array('autocomplete' => 'off' ,'id' =>'test_name','class' => 'form-control','placeholder' => 'Enter test'))}}
              @if($errors->has('test_name'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('test_name')}} </p>
              @endif
            </div>
            <div class="form-group">
              <label for="">Test Hours <span class="mandatory">* </span></label>
              {{Form::text('hours',$test->hours,array('autocomplete' => 'off' ,'id' =>'hours','class' => 'form-control','placeholder' => 'Enter Total Hour'))}}
               <p style="
    color: darkgrey;
    font-size: 11px;
    padding-left: 17px;
    font-weight: 600;
    margin-top: -13px;
    font-style: italic;
">ex: 02:30</p>
               @if($errors->has('hours'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('hours')}} </p>
              @endif
            </div>
           <div class="input-text form-group">
              <label>Category <span class="mandatory">* </span></label>
              {{Form::select('category[]',$categories,'',array('autocomplete' => 'off' ,'id' =>'category','class' => 'form-control select2','multiple'=>''))}}
              @if($errors->has('category'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('category')}} </p>
              @endif
            </div><!-- Field -->
            <div class="input-text form-group">
              <label>Weightage <span class="mandatory">* </span></label>
              {{Form::select('weightage[]',$weightages,'',array('autocomplete' => 'off' ,'id' =>'weightage','class' => 'form-control select2','multiple' => ''))}}
              @if($errors->has('weightage'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('weightage')}} </p>
              @endif
            </div><!-- Field -->
            <div class="form-group">
            <label>Question Type <span class="mandatory">*</span></label>
                <div class="radiobutton">
                    <input type="radio" name="question_usedstatus" id="used" value="1" checked>
                    <label for="used">Used</label><br>
                    <input type="radio" name="question_usedstatus" id="unused" value="0">
                    <label for="unused">Unused</label><br>
                   <!--  <input type="radio" name="question_usedstatus" id="correct" value="2">
                    <label for="correct">Correct </label><br>
                    <input type="radio" name="question_usedstatus" id="incorrect" value="3">
                    <label for="incorrect">Incorrect</label><br> -->
                </div><!-- Radio Button -->
              @if($errors->has('question_usedstatus'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('question_usedstatus')}} </p>
              @endif
            </div><!-- Field -->
            <div class="form-group">
              <label for="">No. Of Questions <span class="mandatory">* </span></label>
              {{Form::text('no_of_question',$test->no_of_question,array('autocomplete' => 'off' ,'id' =>'no_of_question','class' => 'form-control','placeholder' => 'No. Of Questions / 256'))}}
               @if($errors->has('no_of_question'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('no_of_question')}} </p>
              @endif
            </div>
            <div class="form-group">
              <label for="">User Limit<span class="mandatory">* </span></label>
              {{Form::text('user_limit',$test->user_limit,array('autocomplete' => 'off' ,'id' =>'user_limit','class' => 'form-control','placeholder' => 'Enter User Limit'))}}
              @if($errors->has('user_limit'))
              <p style="color:red;font-size: 12px;font-weight: 600;margin-top: -17px !important;"> {{   $errors->first('user_limit')}} </p>
              @endif
            </div>
            <div class="form-group" style="margin-top: 24px;">
              <input type="submit" class="btn btn-primary" value="Submit">
            </div>

          {{Form::close()}}
          </div>
          </div>
        </div>
    </div>
</div>
<style type="text/css">
  select{
    padding: 7px 9px 6px 20px !important;
  }
  .select2-container--default .select2-selection--multiple .select2-selection__choice{
    color: #000;
  }
  input[type="radio"], input[type="checkbox"] {
      vertical-align: middle;
      margin-right: 6px;
  }
</style>
<script type="text/javascript">
   $(document).ready(function() {
         $('.select2').select2();
        });
</script>
@endsection

