

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="title"><?php echo e(__('Edit Profile')); ?></h5>
                </div>
                <form method="post" action="<?php echo e(route('profile.update')); ?>" autocomplete="off">
                    <div class="card-body">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('put'); ?>

                            <?php echo $__env->make('alerts.success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            <div class="form-group<?php echo e($errors->has('name') ? ' has-danger' : ''); ?>">
                                <label><?php echo e(__('Name')); ?></label>
                                <input type="text" name="name" class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" placeholder="<?php echo e(__('Name')); ?>" value="<?php echo e(old('name', auth()->user()->name)); ?>">
                                <?php echo $__env->make('alerts.feedback', ['field' => 'name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <input type="hidden" name="last_name" value="admin">
                                <input type="hidden" name="address" value="admin">
                                <input type="hidden" name="city" value="admin">
                                <input type="hidden" name="zip_code" value="000000">
                                <input type="hidden" name="country" value="India">
                                <input type="hidden" name="mobile" value="0000000000">
                            </div>

                            <div class="form-group<?php echo e($errors->has('email') ? ' has-danger' : ''); ?>">
                                <label><?php echo e(__('Email address')); ?></label>
                                <input type="email" name="email" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" placeholder="<?php echo e(__('Email address')); ?>" value="<?php echo e(old('email', auth()->user()->email)); ?>">
                                <?php echo $__env->make('alerts.feedback', ['field' => 'email'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-fill btn-primary"><?php echo e(__('Save')); ?></button>
                    </div>
                </form>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="title"><?php echo e(__('Password')); ?></h5>
                </div>
                <form method="post" action="<?php echo e(route('profile.password')); ?>" autocomplete="off">
                    <div class="card-body">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('put'); ?>

                        <?php echo $__env->make('alerts.success', ['key' => 'password_status'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <div class="form-group<?php echo e($errors->has('old_password') ? ' has-danger' : ''); ?>">
                            <label><?php echo e(__('Current Password')); ?></label>
                            <input type="password" name="old_password" class="form-control<?php echo e($errors->has('old_password') ? ' is-invalid' : ''); ?>" placeholder="<?php echo e(__('Current Password')); ?>" value="" required>
                            <?php echo $__env->make('alerts.feedback', ['field' => 'old_password'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="form-group<?php echo e($errors->has('password') ? ' has-danger' : ''); ?>">
                            <label><?php echo e(__('New Password')); ?></label>
                            <input type="password" name="password" class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>" placeholder="<?php echo e(__('New Password')); ?>" value="" required>
                            <?php echo $__env->make('alerts.feedback', ['field' => 'password'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="form-group">
                            <label><?php echo e(__('Confirm New Password')); ?></label>
                            <input type="password" name="password_confirmation" class="form-control" placeholder="<?php echo e(__('Confirm New Password')); ?>" value="" required>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-fill btn-primary"><?php echo e(__('Change password')); ?></button>
                    </div>
                </form>
            </div>
            <div class="card">
                <div class="card-header">
                    <h5 class="title"><?php echo e(__('Social Links')); ?></h5>
                </div>
                <form method="post" action="<?php echo e(route('profile.social')); ?>" autocomplete="off">
                    <div class="card-body">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('put'); ?>

                         <?php echo $__env->make('alerts.success', ['key' => 'social_status'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <div class="form-group<?php echo e($errors->has('facebook') ? ' has-danger' : ''); ?>">
                            <label><?php echo e(__('Facebook')); ?></label>
                            <input type="text" name="facebook" required class="form-control<?php echo e($errors->has('facebook') ? ' is-invalid' : ''); ?>" placeholder="<?php echo e(__('Facebook URL')); ?>" value="<?php echo e(auth()->user()->facebook); ?>">
                            <?php echo $__env->make('alerts.feedback', ['field' => 'facebook'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="form-group<?php echo e($errors->has('twitter') ? ' has-danger' : ''); ?>">
                            <label><?php echo e(__('Twitter')); ?></label>
                            <input type="text" name="twitter" required  class="form-control<?php echo e($errors->has('twitter') ? ' is-invalid' : ''); ?>" placeholder="<?php echo e(__('Twitter URL')); ?>" value="<?php echo e(auth()->user()->twitter); ?>">
                            <?php echo $__env->make('alerts.feedback', ['field' => 'twitter'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="form-group">
                            <label><?php echo e(__('Google Plus')); ?></label>
                            <input type="text" name="google_plus" required  class="form-control" placeholder="<?php echo e(__('Google Plus URL')); ?>" value="<?php echo e(auth()->user()->google_plus); ?>">
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-fill btn-primary"><?php echo e(__('Update')); ?></button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card card-user">
                <div class="card-body">
                    <p class="card-text">
                        <div class="author">
                            <div class="block block-one"></div>
                            <div class="block block-two"></div>
                            <div class="block block-three"></div>
                            <div class="block block-four"></div>
                            <a href="#">
                                <img class="avatar" src="<?php echo e(asset('black')); ?>/img/emilyz.jpg" alt="">
                                <h5 class="title"><?php echo e(auth()->user()->name); ?></h5>
                                <h5 class="title"><?php echo e(auth()->user()->email); ?></h5>
                            </a>
                        </div>
                    </p>
                </div>
                <div class="card-footer">
                    <div class="button-container">
                        <button class="btn btn-icon btn-round btn-facebook">
                            <a style="color:#fff;" href="<?php echo e(auth()->user()->facebook); ?>"><i class="fab fa-facebook"></i></a>
                        </button>
                        <button class="btn btn-icon btn-round btn-twitter">
                            <a style="color:#fff;" href="<?php echo e(auth()->user()->twitter); ?>"><i class="fab fa-twitter"></i></a>
                        </button>
                        <button class="btn btn-icon btn-round btn-google">
                            <a style="color:#fff;" href="<?php echo e(auth()->user()->google_plus); ?>"><i class="fab fa-google-plus"></i></a>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['page' => __('User Profile'), 'pageSlug' => 'profile'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sibzsolu/public_html/training/stimclex/resources/views/profile/edit.blade.php ENDPATH**/ ?>