@extends('layouts.app', ['pageSlug' => 'questions'])
@push('style')
<link rel="stylesheet" type="text/css" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
@endpush
@section('content')
<div class="container">
    <div class="row ">
        <div class="col-md-12">

          @if(session()->has('message'))
            <p class="btn btn-success btn-block btn-sm custom_message text-left">{{ session()->get('message') }}</p>
          @endif

          <div class="card ">
            <div class="card-header">
                <div class="row">
                    <div class="col-8">
                        <h4 class="card-title">Questions List</h4>
                    </div>
                    <div class="col-4 text-right">
                        <a href="{{ route('addquestion') }}" class="btn btn-sm btn-primary">Add Questions</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                
                <div class="">
                    <table class="table tablesorter " id="">
                        <thead class=" text-primary">
                            <tr>
                            <th scope="col">No</th>
                            <th scope="col">Question</th>
                            <th scope="col">category Name</th>
                            <th scope="col">Weightage Title</th>
                            <th scope="col">Question Category</th>
                            
                            <th scope="col">ACTION</th>
                        </tr></thead>
                        <tbody>
                         @forelse ($questions as $ques)
                        <tr>
                          <td>{{ $loop->index + 1 }}</td>
                          <td>{{ $ques->question }}</td>
                          <td>{{ $ques->category_name }}</td>
                          <td>{{ $ques->weightage_title }}</td>
                           <td>{{ $ques->question_category }}</td>
                          <td>
                          <a href="{{ route('editquestion',$ques->id) }}" class="btn btn-sm btn-outline-primary py-0">Edit</a>
                          <!-- <a  href="deletequestion/{{ $ques->id }}" class="btn btn-sm btn-outline-danger py-0" onclick="return confirm('Are you sure, you want to delete it?')">Delete</a> -->
                          <a style="margin-left: 10px;" href="deletequestion/{{ $ques->id }}" class="btn btn-sm btn-outline-danger py-0 quesdel{{ $ques->id }}"  onclick="confirmpage('quesdel<?php echo $ques->id;?>');return false;">Delete</a>
                          </td>
                        </tr>
                         @empty
                        <tr><td colspan="4" class="text-center"> No Questions found!</td></tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        </div>
    </div>
</div>
@endsection