<?php

namespace App\Http\Controllers\Userdashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Test;
use DB;
class ExamController extends Controller
{
    public function index(){
    	
        return view('Userdashboard/examlist');
    }
   
    /* Process ajax request */
    public function getExam(Request $request)
    {

        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); // total number of rows per page

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column']; // Column index
        $columnName = $columnName_arr[$columnIndex]['data']; // Column name
        $columnSortOrder = $order_arr[0]['dir']; // asc or desc
        $columnSortOrder="asc";
        $searchValue = $search_arr['value']; // Search value

        // Total records
        $totalRecords = Test::select('count(*) as allcount')->count();
        $totalRecordswithFilter = Test::select('count(*) as allcount')->where('test_name', 'like', '%' . $searchValue . '%')->count();

        // Get records, also we have included search filter as well
        $records = Test::orderBy($columnName, $columnSortOrder)
            ->where('tests.test_name', 'like', '%' . $searchValue . '%')
            // ->orWhere('students.', 'like', '%' . $searchValue . '%')
            // ->orWhere('students.branch', 'like', '%' . $searchValue . '%')
            ->select('tests.*')
            ->skip($start)
            ->take($rowperpage)
            ->get();

        $data_arr = array();

        foreach ($records as $record) {

            $data_arr[] = array(
                "id" => $record->id,
                "test_name" => $record->test_name,
                "hours" => $record->hours,
                "action" => "<a href='".route('quiz' , $record->id)."' type='button' class='btn btn-success'>Start Exam</a>",
            );
        }

        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr,
        );

        echo json_encode($response);
    }
   
}
