<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Auth::routes();

Route::get('/home', 'App\Http\Controllers\HomeController@index')->name('home')->middleware('auth');

Route::group(['middleware' => 'auth'], function () {
		Route::get('icons', ['as' => 'pages.icons', 'uses' => 'App\Http\Controllers\PageController@icons']);
		Route::get('maps', ['as' => 'pages.maps', 'uses' => 'App\Http\Controllers\PageController@maps']);
		Route::get('notifications', ['as' => 'pages.notifications', 'uses' => 'App\Http\Controllers\PageController@notifications']);
		Route::get('rtl', ['as' => 'pages.rtl', 'uses' => 'App\Http\Controllers\PageController@rtl']);
		Route::get('tables', ['as' => 'pages.tables', 'uses' => 'App\Http\Controllers\PageController@tables']);
		Route::get('typography', ['as' => 'pages.typography', 'uses' => 'App\Http\Controllers\PageController@typography']);
		Route::get('upgrade', ['as' => 'pages.upgrade', 'uses' => 'App\Http\Controllers\PageController@upgrade']);
});

	Route::group(['middleware' => 'auth'], function () {
	Route::resource('user', 'App\Http\Controllers\UserController', ['except' => ['show']]);
	Route::get('profile', ['as' => 'profile.edit', 'uses' => 'App\Http\Controllers\ProfileController@edit']);
	Route::put('profile', ['as' => 'profile.update', 'uses' => 'App\Http\Controllers\ProfileController@update']);
	Route::put('profile/password', ['as' => 'profile.password', 'uses' => 'App\Http\Controllers\ProfileController@password']);
});
	// Category Master
	
	Route::get('/addcategory', 'App\Http\Controllers\CategoryController@addcategory')->name('addcategory');
	Route::post('/addcategory', 'App\Http\Controllers\CategoryController@storecategory');
	Route::get('/category', 'App\Http\Controllers\CategoryController@index')->name('category');
	Route::get('/category/editcategory/{category}', 'App\Http\Controllers\CategoryController@editcategory')->name('category.editcategory');
	Route::patch('/category/editcategory/{category}', 'App\Http\Controllers\CategoryController@updatecategory')->name('category.updatecategory');
	Route::get('category/{id}','App\Http\Controllers\CategoryController@delete_category');

	//Weightage Master

	Route::get('/weightage', 'App\Http\Controllers\WeightageController@index')->name('weightage');
	Route::get('/addweightage', 'App\Http\Controllers\WeightageController@addweightage')->name('addweightage');
	Route::post('/addweightage', 'App\Http\Controllers\WeightageController@storeweightage');
	Route::get('/weightage/editweightage/{weightage}', 'App\Http\Controllers\WeightageController@editweightage')->name('weightage.editweightage');
	Route::patch('/weightage/editweightage/{weightage}', 'App\Http\Controllers\WeightageController@updateweightage')->name('weightage.updateweightage');
	Route::get('weightage/{id}','App\Http\Controllers\WeightageController@delete_weightage');
 
	
	//Question Category Master
	Route::get('/addquestioncategory', 'App\Http\Controllers\QuestionCategoryController@add')->name('addquestioncategory');
	Route::post('/addquestioncategory', 'App\Http\Controllers\QuestionCategoryController@save');
	Route::patch('/addquestioncategory/{id}', 'App\Http\Controllers\QuestionCategoryController@save')->name('updatequestcategory');
	Route::get('/question-category/list', 'App\Http\Controllers\QuestionCategoryController@list')->name('listquestioncategory');
	Route::get('/question-category/edit/{id}', 'App\Http\Controllers\QuestionCategoryController@edit')->name('editquestioncategory');
	Route::get('question-category/delete/{id}','App\Http\Controllers\QuestionCategoryController@delete')->name('deletequestioncategory');

	//Tag Master
	Route::get('/add/tag', 'App\Http\Controllers\TagsController@add')->name('addtag');
	Route::post('/add/tag', 'App\Http\Controllers\TagsController@save');
	Route::patch('/tag/{id}', 'App\Http\Controllers\TagsController@save')->name('updatetag');
	Route::get('/tag/list', 'App\Http\Controllers\TagsController@list')->name('listtag');
	Route::get('/tag/edit/{id}', 'App\Http\Controllers\TagsController@edit')->name('edittag');
	Route::get('/tag/delete/{id}','App\Http\Controllers\TagsController@delete')->name('deletetag');