@extends('layouts.app', ['pageSlug' => 'questioncategory'])
@section('content')
<!-- Content Wrap -->
<div class="content-wrap">
    <div class="page-header">
        <div class="container">
            <div class="row">
                <div class="col-md-12">   
                    <div class="page-header-inner page-title">
                        <p class="sub-title">Masters</p>
                        <h3 class="title">Company Masters</h3>
                    </div><!-- Page Header Inner -->
                    <!-- <div class="page-header-inner">
                        <div class="input-group search">
                            <span class="input-group-addon ion-ios-search-strong"></span>
                            <input type="text" name="search" id="search" class="form-control" placeholder="Find Company">
                        </div>
                    </div> --><!-- Page Header Inner -->
                    <div class="page-header-inner page-right">
                        <a href="{{url('master/company/add')}}" class="btn btn-secondary">ADD NEW COMPANY</a>
                    </div><!-- Page Header Inner -->  
                </div><!-- Col Main -->
            </div><!-- Row -->
        </div><!-- Container -->
    </div><!-- Page Header -->
    
    <!-- Page Main Content -->
    <div class="page-main-content">
        <div class="container">
            <div class="row">
                <div class="col-md-12">  
                    <div class="page-content-inner"> 
                        <div class="row">
                            <div class="col-md-10 col-sm-9">
                                <ul class="btn-set myBtn">
                                    <li><p>Category</p></li>
                                    <li><button class="btn btn-white active filter-types" onclick="filterSelection(1)" id="all-type" data-type="-1">ALL</button></li>
                                    <li><a class="btn btn-white filter-types" onclick="filterSelection(2)" id="type-own" data-type="0">OWN</a></li>
                                    <li><a class="btn btn-white filter-types" onclick="filterSelection(3)" id="type-contract" data-type="1">CONTRACT COMPANIES</a></li>
                                    <input type="hidden" name="fil_types" id="fil_types" value="">
                                </ul><!-- button Set -->
                            </div><!-- Column -->
                            <div class="col-md-2 col-sm-3">
                                <div class="tab-wrap">
                                    <div class="isotope-filters animated" data-animation="fadeInLeft" data-animation-delay="300">
                                        <ul class="nav nav-pills">
                                            <li class="active"><a href="#" class="filter active" data-target="#row-view" data-toggle="tab" aria-expanded="true"><i class="ion-android-menu"></i></a></li>
                                            <li><a href="#" data-target="#card-view" data-toggle="tab" aria-expanded="true" class="filter non-active"><i class="ion-grid"></i></a></li>
                                        </ul>
                                    </div><!-- Filters -->
                                </div><!-- Text Right -->
                            </div><!-- Column -->  
                        </div><!-- Row -->  
                        
                        <!-- Tab Content -->          
                        <div class="tab-content">
                            <!-- TAB PANEL -->
                            <div class="tab-pane fade animated" id="card-view" data-animation="fadeInUp" data-animation-delay="300">
                                <div class="tab-content-inner">
                                    <ul class="card-list tab_search">
                                        @foreach($company as $row)
                                        <li class="card-list-item {{$row->type==1?'contract':'own'}} ">
                                            <div class="card-box">
                                                <div class="card-edit">
                                                    <a href="{{route('editCompanyMaster',['company_id' => $row->id])}}" class="btn btn-edit"><i class="ion-edit"></i></a>
                                                </div><!-- Card Edit -->
                                                <div class="card-header">
                                                    <h5 class="card-title">{{$row->comp_name}}</h5>
                                                    <p class="card-sub-title">{{$row->short_code}}</p>
                                                    <?php if($row->type== '0'){ $row->type= "OWN"; }else{ $row->type= "CONTRACT"; } ?>
                                                    <p class="card-small">Type: <span>{{$row->type}}</span></p>
                                                </div><!-- Card Header -->
                                                <div class="card-body">
                                                    <p>Employees: <span>{{$row->tot_count}}</span></p>
                                                </div><!-- Card Body -->
                                                <div class="card-footer">
                                                    <a href="{{route('viewCompanyMaster',['company_id' => $row->id])}}" class="btn btn-white">View</a>
                                                </div><!-- Card Footer -->
                                            </div><!-- Card Box -->
                                        </li><!-- List Item -->
                                       @endforeach                                     
                                    </ul><!-- Card List -->
                                </div><!-- Tab Content Inner --> 
                            </div><!-- Tab Panel -->
                            <div class="tab-pane fade in active animated" id="row-view" data-animation="fadeInUp" data-animation-delay="300">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table class="table table-light table-edit " id="company_tab" style="width: 100% !important;">
                                                <thead>
                                                    <tr>
                                                        <th>Company Name</th>
                                                        <th>Company Short Code</th>
                                                        <th>Type</th>
                                                        <th>Total Employees</th>
                                                        <th>Employees</th>
                                                        <th>Contract Employees</th>
                                                        <th>Guests</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody class="tab_search">
                                                    <!-- @foreach($company as $row)
                                                    <tr class="table-filter {{$row->type=="CONTRACT"?'contract':'own'}}">
                                                        <td>{{$row->comp_name}}</td>
                                                        <td>{{$row->short_code}}</td>
                                                        <td>{{$row->type}}</td>
                                                        <td>{{$row->tot_count}}</td>
                                                        <td>{{$row->emp_count}}</td>
                                                        <td>{{$row->cont_count}}</td>
                                                        <td>{{$row->guest_count}}</td>
                                                        <td class="td-edit"><a href="{{route('viewCompanyMaster',['company_id' => $row->id])}}"><img src="{{ URL::asset('public/img/content/arrow/next.svg') }}" class="img-responsive"></a></td>
                                                    </tr>
                                                    @endforeach -->
                                                </tbody>
                                            </table>
                                        </div><!-- Table Responsive -->
                                    </div><!-- Column -->
                                </div><!-- Row -->
                            </div><!-- Tab panel -->
                        </div><!-- Tab Content -->
                    </div><!-- Page Content Inner -->
                </div><!-- Col Main -->
            </div><!-- Row Main -->
        </div><!-- Container -->
    </div><!-- Page Main Content -->
</div><!-- Content Wrap -->
@endsection

@section('footer_scripts')
<script type="text/javascript">
    $(document).ready(function(){
  $('.btn').click(function(){
    $('.btn').removeClass('active').addClass('inactive');
     $(this).removeClass('inactive').addClass('active');
    });

  $('.filter-types').click(function(){
    var fils= $(this).attr('data-type');
    $('.filter-types').val(fils);
  });

});
</script>

<script type="text/javascript" src="{{URL::asset('public/js/masters/app-company-master.js?v=1')}}"></script>
<script type="text/javascript">
    var save_company_master= "{{route('saveCompanyMaster')}}";
    var list_company_master= "{{route('listCompanyMaster')}}";
    var get_list_comp= "{{route('getCompanyList')}}";

</script>

@endsection